/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.gameObjs.container.slots.HotBarSlot;
import moze_intel.projecte.gameObjs.container.slots.IInsertableSlot;
import moze_intel.projecte.gameObjs.container.slots.InventoryContainerSlot;
import moze_intel.projecte.gameObjs.container.slots.MainInventorySlot;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.IPEPacket;
import moze_intel.projecte.network.packets.to_client.UpdateWindowIntPKT;
import moze_intel.projecte.network.packets.to_client.UpdateWindowLongPKT;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PEContainer
extends AbstractContainerMenu {
    protected final List<InventoryContainerSlot> inventoryContainerSlots = new ArrayList<InventoryContainerSlot>();
    protected final List<MainInventorySlot> mainInventorySlots = new ArrayList<MainInventorySlot>();
    protected final List<HotBarSlot> hotBarSlots = new ArrayList<HotBarSlot>();
    private final List<DataSlot> intFields = new ArrayList<DataSlot>();
    protected final List<BoxedLong> longFields = new ArrayList<BoxedLong>();
    protected final Inventory playerInv;

    protected PEContainer(ContainerTypeRegistryObject<? extends PEContainer> typeRO, int id, Inventory playerInv) {
        super((MenuType)typeRO.get(), id);
        this.playerInv = playerInv;
    }

    protected void addPlayerInventory(int xStart, int yStart) {
        int i;
        int slotSize = 18;
        int rows = 3;
        for (i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(this.createMainInventorySlot(this.playerInv, j + i * 9 + 9, xStart + j * slotSize, yStart + i * slotSize));
            }
        }
        yStart = yStart + slotSize * rows + 4;
        for (i = 0; i < Inventory.m_36059_(); ++i) {
            this.m_38897_(this.createHotBarSlot(this.playerInv, i, xStart + i * slotSize, yStart));
        }
    }

    protected MainInventorySlot createMainInventorySlot(@NotNull Inventory inv, int index, int x, int y) {
        return new MainInventorySlot((Container)inv, index, x, y);
    }

    protected HotBarSlot createHotBarSlot(@NotNull Inventory inv, int index, int x, int y) {
        return new HotBarSlot((Container)inv, index, x, y);
    }

    @NotNull
    protected Slot m_38897_(@NotNull Slot slot) {
        super.m_38897_(slot);
        if (slot instanceof InventoryContainerSlot) {
            InventoryContainerSlot containerSlot = (InventoryContainerSlot)slot;
            this.inventoryContainerSlots.add(containerSlot);
        } else if (slot instanceof MainInventorySlot) {
            MainInventorySlot inventorySlot = (MainInventorySlot)slot;
            this.mainInventorySlots.add(inventorySlot);
        } else if (slot instanceof HotBarSlot) {
            HotBarSlot hotBarSlot = (HotBarSlot)slot;
            this.hotBarSlots.add(hotBarSlot);
        }
        return slot;
    }

    @Nullable
    public Slot tryGetSlot(int slotId) {
        if (slotId >= 0 && slotId < this.f_38839_.size()) {
            return this.m_38853_(slotId);
        }
        return null;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotID) {
        ItemStack slotStack;
        Slot currentSlot = (Slot)this.f_38839_.get(slotID);
        if (currentSlot == null || !currentSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackToInsert = slotStack = currentSlot.m_7993_();
        if (currentSlot instanceof InventoryContainerSlot) {
            stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, true);
            stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, true);
            stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, false);
            stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, false);
        } else {
            stackToInsert = PEContainer.insertItem(this.inventoryContainerSlots, stackToInsert, true);
            if (slotStack.m_41613_() == stackToInsert.m_41613_()) {
                stackToInsert = PEContainer.insertItem(this.inventoryContainerSlots, stackToInsert, false);
                if (slotStack.m_41613_() == stackToInsert.m_41613_()) {
                    if (currentSlot instanceof MainInventorySlot) {
                        stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, true);
                        stackToInsert = PEContainer.insertItem(this.hotBarSlots, stackToInsert, false);
                    } else if (currentSlot instanceof HotBarSlot) {
                        stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, true);
                        stackToInsert = PEContainer.insertItem(this.mainInventorySlots, stackToInsert, false);
                    }
                }
            }
        }
        if (stackToInsert.m_41613_() == slotStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        return this.transferSuccess(currentSlot, player, slotStack, stackToInsert);
    }

    @NotNull
    protected ItemStack transferSuccess(@NotNull Slot currentSlot, @NotNull Player player, @NotNull ItemStack slotStack, @NotNull ItemStack stackToInsert) {
        int difference = slotStack.m_41613_() - stackToInsert.m_41613_();
        currentSlot.m_6201_(difference);
        ItemStack newStack = ItemHelper.size(slotStack, difference);
        currentSlot.m_142406_(player, newStack);
        return newStack;
    }

    @NotNull
    public static <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @NotNull ItemStack stack, boolean ignoreEmpty) {
        Slot slot;
        if (stack.m_41619_()) {
            return stack;
        }
        Iterator<SLOT> iterator = slots.iterator();
        while (iterator.hasNext() && (ignoreEmpty != (slot = (Slot)iterator.next()).m_6657_() || !(stack = ((IInsertableSlot)slot).insertItem(stack, false)).m_41619_())) {
        }
        return stack;
    }

    protected static boolean stillValid(Player player, BlockEntity blockEntity, BlockRegistryObject<?, ?> blockRO) {
        BlockPos pos = blockEntity.m_58899_();
        return player.f_19853_.m_8055_(pos).m_60734_() == blockRO.getBlock() && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
    }

    public final void updateProgressBarLong(int idx, long data) {
        this.longFields.get(idx).set(data);
    }

    public final void updateProgressBarInt(int idx, int data) {
        this.intFields.get(idx).m_6422_(data);
    }

    @NotNull
    protected DataSlot m_38895_(@NotNull DataSlot referenceHolder) {
        this.intFields.add(referenceHolder);
        return referenceHolder;
    }

    protected void broadcastPE(boolean all) {
        int i;
        for (i = 0; i < this.longFields.size(); ++i) {
            BoxedLong boxedLong = this.longFields.get(i);
            if (!boxedLong.isDirty() && !all) continue;
            this.syncDataChange(new UpdateWindowLongPKT((short)this.f_38840_, (short)i, boxedLong.get()));
        }
        for (i = 0; i < this.intFields.size(); ++i) {
            DataSlot referenceHolder = this.intFields.get(i);
            if (!referenceHolder.m_39409_() && !all) continue;
            this.syncDataChange(new UpdateWindowIntPKT((short)this.f_38840_, (short)i, referenceHolder.m_6501_()));
        }
    }

    public void m_38946_() {
        super.m_38946_();
        this.broadcastPE(false);
    }

    public void m_150429_() {
        super.m_150429_();
        this.broadcastPE(true);
    }

    protected void syncDataChange(IPEPacket packet) {
        Player player = this.playerInv.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketHandler.sendTo(packet, player2);
        }
    }

    public static class BoxedLong {
        private long inner;
        private boolean dirty = false;

        public long get() {
            return this.inner;
        }

        public void set(long v) {
            if (v != this.inner) {
                this.inner = v;
                this.dirty = true;
            }
        }

        public boolean isDirty() {
            boolean ret = this.dirty;
            this.dirty = false;
            return ret;
        }
    }
}

